package project;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author dipti
 */
import java.util.regex.*;

public class ValidationFunctions {
    public static boolean isValidEmail(String email) {
        // Regular expression for email validation
        String emailRegex = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
        Pattern pattern = Pattern.compile(emailRegex);
        return pattern.matcher(email).matches();
    }

    public static boolean isValidMobileNumber(String mobileNumber) {
        // Regular expression for mobile number validation (Indian format)
        String mobileRegex = "^[6-9]\\d{9}$";
        Pattern pattern = Pattern.compile(mobileRegex);
        return pattern.matcher(mobileNumber).matches();
    }

    public static boolean isValidPassword(String password) {
        // Password validation (At least 8 characters, one uppercase letter, one lowercase letter, one digit, and one special character)
        String passwordRegex = "^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%^&+=])(?=\\S+$).{8,}$";
        Pattern pattern = Pattern.compile(passwordRegex);
        return pattern.matcher(password).matches();
    }
}

