
package project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.*;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;


@WebServlet("/uploadSalarySlips")
@MultipartConfig(fileSizeThreshold=1024*1024,
maxFileSize=1024*1024*2,
maxRequestSize=1024*1024*5)
public class uploadSalarySlips extends HttpServlet {

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out=response.getWriter();
            String payroll_id = request.getParameter("payroll_id");
            String emp_code = request.getParameter("emp_code");
            String email = request.getParameter("email");
            String date = request.getParameter("date");
            String month = request.getParameter("month");
            String year = request.getParameter("year");
            
            
            Part part=request.getPart("file");
       
       String fileName=extractFileName(part);
       String filePath="C:\\Users\\dipti\\OneDrive\\Desktop\\Project CLINIHR\\CLINIHR\\web\\Salaryslips"+File.separator+fileName;
        File fileSaveDir=new File(filePath);
      try {
    InputStream inputStream = part.getInputStream();
    Path outputPath = Paths.get(filePath);
    Files.copy(inputStream, outputPath, StandardCopyOption.REPLACE_EXISTING);
} catch (IOException ex) {
    out.print(ex);
}
try{
    Class.forName("com.mysql.jdbc.Driver");
    Connection con = DriverManager.getConnection("jdbc:mysql://localhost:3306/CLINIHR", "root", "Clinica123");
    PreparedStatement ps=con.prepareStatement("insert into emp_payroll(payroll_id, emp_code, email, date, month, year, file_name, file_path) values(?,?,?,?,?,?,?,?)");
                ps.setString(1, payroll_id);
                ps.setString(2, emp_code);
                ps.setString(3, email);
                ps.setString(4, date);
                ps.setString(5, month);
                ps.setString(6, year);
                ps.setString(7, fileName);
                ps.setString(8, filePath);
               // Perform validation
    boolean isValid = true;
    String errorMsg = "";

    // Example validation: Check if any field is empty
    if (emp_code.isEmpty() || email.isEmpty() || date.isEmpty() || month.isEmpty() || year.isEmpty() || fileName.isEmpty() || filePath.isEmpty() ) {
        isValid = false;
        errorMsg = "All fields must be filled out";
    } /*else {
        // Email validation
        if (!ValidationFunctions.isValidEmail(email)) {
            isValid = false;
            errorMsg = "Invalid email address";
            response.sendRedirect("registerEmployee.jsp?msg=invalidEmail&error=" + java.net.URLEncoder.encode(errorMsg, "UTF-8"));
        }

        // Mobile number validation
        if (!ValidationFunctions.isValidMobileNumber(mobile_number)) {
            isValid = false;
            errorMsg = "Invalid mobile number";
        response.sendRedirect("registerEmployee.jsp?msg=invalidNumber&error=" + java.net.URLEncoder.encode(errorMsg, "UTF-8"));
        

        //Password validation
        if (!ValidationFunctions.isValidPassword(password)) {
            isValid = false;
            errorMsg = "Invalid password";
            response.sendRedirect("registerEmployee.jsp?msg=invalidPassword&error=" + java.net.URLEncoder.encode(errorMsg, "UTF-8"));
        }
}
    }*/

    if (isValid) {
        // Proceed with registration
        // This is where you would insert the data into the database
        // Redirect or display success message
        ps.executeUpdate();
        response.sendRedirect("allSalarySlip.jsp?msg=done");
    } else {
        // Display error message
        response.sendRedirect("allSalarySlip.jsp?msg=wrong&error=" + java.net.URLEncoder.encode(errorMsg, "UTF-8"));
    }
}
    catch(  IOException | ClassNotFoundException | SQLException e){
    out.println(e);
    //response.sendRedirect("registerEmployee.jsp?msg=invalid");
}
    }
    @Override
    public String getServletInfo() {
        return "Short description";
    }

    private String extractFileName(Part part) {
     String contentDisp=part.getHeader("content-disposition");
        String[] items=contentDisp.split(";");
        for(String s:items){
        if(s.trim().startsWith("filename")){
        return s.substring(s.indexOf("=")+2,s.length()-1);
        }
        }
        return"";
    }

}
