<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>About</title>
<style>
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

.heading {
    text-align: center;
    color: navy;
    font-size: 36px;
}

.subheading {
    text-align: center;
    font-size: 20px;
    margin-top: 10px;
    margin-bottom: 20px;
}

.image {
    width: 50%;
    height: auto;
    border-radius: 10px;
    display: block;
    margin: 0 auto;
}

.section {
    padding: 20px;
    margin-bottom: 20px;
}

.section h2 {
    color: navy;
    font-size: 24px;
    margin-bottom: 10px;
}

.section h4 {
    font-size: 18px;
    margin-bottom: 5px;
}

.section p {
    margin-bottom: 10px;
}

.section:last-child {
    margin-bottom: 0;
}
</style>
</head>
<body>

<div class="container">

    <div class="heading">Together, we can do far better.</div>
    
    <div class="subheading">Roadmap to raise research-to-reality through our expertise, resources and services. We together transform your idea with our dedication, knowledge, and confidence to certainty.</div>
    
    <img src="images/about.jpg" class="image" alt="me">
    
    <div class="section">
        <h2>Clinical Operations</h2>
        <h4>CLINICA provides expert services in all key areas of the Clinical operations process including:</h4>
        <p>Selection of sites and Feasibility Assessment</p>
        <p>Project Planning and Initiation</p>
        <!-- Add more content here -->
        <h4>Project Management:</h4>
<p>Project Management is our major competence.</p>
<p>CLINICA Project Managers have:</p>
<ul>
    <li>Extensive experience in the conducting complex clinical trials, which is essential to study success</li>
    <li>Track Record of successfully completing the studies</li>
    <li>Therapeutic Area Expertise</li>
    <li>Identifies Risk and their mitigation strategy</li>
    <li>Project Planning, Training and Kick-off</li>
</ul>
<p>Project Oversight and Reporting:</p>
<ul>
    <li>Manage the project timelines and budget</li>
    <li>Track study activity and reporting throughout project duration to the sponsor</li>
    <li>Vendor Management</li>
    <li>CLINICA performs Vendor selection, qualification, contracting, and payment administration</li>
    <li>End-to-end management of critical study vendors (e.g. drug depot, lab, IRB/EC, eTMF, EDC, IWRS/IVRS)</li>
</ul>
<p>Regulatory support:</p>
<ul>
    <li>CLINICA provides comprehensive support for our drug development partners to overcome the hurdles linked with the requirements of the DCGI, FDA, EMA and Other Regulatory authorities</li>
    <li>Preparing regulatory package for Regulatory Authorities, Clinical Trial Insurance</li>
    <li>Coordinating and submitting Protocol or Protocol Amendments</li>
    <li>CT NOC and Import License, Import/Export Management</li>
    <li>Submitting interim and annual reports</li>
    <li>Communication with Regulatory Authority</li>
    <li>CTRI Registration</li>
    <li>Product Registration and Marketing Approval</li>
</ul>

    </div>
    
    <div class="section">
        <h3 style="color: navy">Data Management</h3>
<p>CLINICA provides complete data management services through our expert team proficient in various clinical software tools.</p>
<p>Data management services include:</p>
<ul>
    <li>CRF Development</li>
    <li>Database Programming and Development</li>
    <li>Data validation and analysis</li>
    <li>Edit checks</li>
    <li>Querying the data for completion</li>
    <li>Creation of study reports</li>
    <li>Database Lock</li>
    <li>Data quality Control and Cleaning</li>
</ul>
<p>Project Management:</p>
<ul>
    <li>Project Management is our strength</li>
    <li>Project Oversight and Reporting</li>
    <li>Vendor Management</li>
</ul>

    </div>
    
    <div class="section">
       <h3 style="color: navy">Biostatistics</h3>
<p>CLINICA Biostatistics team has worked on SAS and other Biostatistics Software, expert in programming and reporting accuracy necessary to deliver your trial results.</p>
<p>We provide below services to our partners:</p>
<ul>
    <li>Trial design consultation</li>
    <li>Statistical methodology recommendations</li>
    <li>Sample size determinations with detailed descriptions of statistical methodologies</li>
    <li>Preparation and generation of randomization plans</li>
    <li>Statistical Analysis</li>
    <li>Writing support for study reports and manuscripts</li>
</ul>
<p>Project Management:</p>
<ul>
    <li>Project Management is our strength</li>
    <li>Project Oversight and Reporting</li>
    <li>Vendor Management</li>
</ul>

    </div>
    
    <div class="section">
        <h3 style="color: navy">Quality Assurance</h3>
<p>CLINICA's dedicated Quality and Compliance team have extensive experience in conducting all types of audits on a Global basis. We implement quality by a system-based approach to the design, development, and delivery of services to our clients. In addition to a comprehensive internal clinical quality assurance program, we provide clinical QA & QC services to our clients as a part of either a full-service or a stand-alone project.</p>
<p>We provide below QA services as stand-alone:</p>
<ul>
    <li>Investigator site audits</li>
    <li>Quality event management/CAPA</li>
    <li>Vendor audits</li>
    <li>System and process audits</li>
    <li>GLP audits</li>
    <li>Oversight and management of document control</li>
    <li>Internal Audits</li>
    <li>Regulatory Training (GLP, GMP, GCP)</li>
    <li>Regulatory Inspection Preparation/Mock Regulatory Inspections support and management</li>
</ul>
<p>Project Management:</p>
<ul>
    <li>Project Management is our strength</li>
    <li>Project Oversight and Reporting</li>
    <li>Vendor Management</li>
</ul>

    </div>
    
    <div class="section">
        <h3 style="color: navy">Medical Writing</h3>
<p>The Medical writers at CLINICA are experts in writing Regulatory and Non-regulatory project work with ease. We do offer stand-alone Medical Writing services to our esteemed partners.</p>
<p>We provide the following Medical Writing services as stand-alone:</p>
<ul>
    <li>Project Specific writing:</li>
    <ul>
        <li>Feasibility survey reports, disease demographics from India and other territories</li>
        <li>Protocol</li>
        <li>Clinical study report</li>
        <li>Informed consent documents</li>
        <li>Subject diaries</li>
        <li>Case report forms</li>
        <li>Patient support aids</li>
    </ul>
    <li>Regulatory Writing:</li>
    <ul>
        <li>Investigational Medical Product Dossier (IMPD)</li>
        <li>Investigator Brochure (IB)</li>
        <li>Clinical & non clinical sections of the Common Technical Document (CTD) including summaries and overviews for EU or US Regulatory Authorities</li>
        <li>Product Monographs</li>
        <li>Executive Summary for DCGI submission and SEC presentation</li>
        <li>Registration on Web (Clintrial.gov, EU clinical register, CTRI etc)</li>
    </ul>
    <li>Scientific Writing:Publication Support</li>
    <ul>
        <li>Peer-reviewed Publications (from publication planning to journal submissions)</li>
        <li>Abstracts, posters, slide-sets, conference coverage</li>
        <li>Medico Marketing Support</li>
        <ul>
            <li>Flash cards, Detail Visual aids, Leave Behind Leaflets (LBLs)</li>
            <li>Newsletters</li>
            <li>Drug Brochures/Product Monographs</li>
            <li>Booklets/Compendiums</li>
            <li>Patient educational materials</li>
            <li>CME Slides/Abstracts</li>
            <li>Training Documents</li>
            <li>Online Learning/ Training modules</li>
        </ul>
    </ul>
</ul>

    </div>
    
    <div class="section">
        <h3 style="color: navy">Consultation</h3>
<p>CLINICA, through our expertise of more than two decades in the industry, we offer consultation to various development partners.</p>
<p>We offer Consultation in the following areas:</p>
<ul>
    <li>Investigator Initiated Studies</li>
    <li>Conceptualization of studies in Herbal and Homeopathic Medicines</li>
    <li>Customized Training Courses</li>
    <li>Insourcing Mandates</li>
    <li>Blog</li>
    <li>Site Management</li>
</ul>
<p>CLINICA believes that effective site management adds positive momentum to successful patient recruitment and patient compliance, which secures the success of clinical trial deliverables.</p>
<p>Under site management services, we contract with the trial sites (hospitals and medical institutions) and assist with trial work so that trials can be conducted as per the protocol, ICH GCP guidelines, and desired regulatory requirements without any interruption. We have a team of experienced & trained Clinical Research Coordinators (CRCs), Nurses, Pharmacists & Phlebotomists who constitute our Site Management service vertical. Our staff is trained in ICH-GCP, Indian Regulations to conduct the study and also on the International regulations to ease Study Execution & Documentations of the highest Quality & Standard.</p>

    </div>

</div>

</body>
</html>
